
// This scilab code is used to perform Hough Transform operation on the image
//to extract the features from image.

//The scilab environment for this is : Scilab 6.0.1

//Toolbox used: Image Processing and Computer Vision Toolbox ver. 1.1
              

//OS used : Windows 10 64 bit
// 
//Reference book name : Digital Image Processing
//book author: Rafael C. Gonzalez and Richard E. Woods

//clc //to clear command window.
//clear all //to kill previously defined variables.
//xdel(winsid())//to close all currently open figure(s).

//This code uses an circle image pic26.png file for processing

S = imread('pic26.png');                    // Read input image using imread function
[houghmat, dist, theta] = imhough(S);       // Apply hough transformation
                                            // This returns hough matrix houghmat
                                            // distance from center to the point
                                            // and angle of point to the center 

f=scf();                                    // Assign current graphics window handle to f
f.color_map=hotcolormap(64);                // Change colormap for current graphics window
Sgrayplot(theta,dist,houghmat',strf="021"); // Plots smooth 2D surface
